﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Menu.Sample4
{
    public partial class FormMain : Form
    {
        public const int MF_ByPosition = 0x400;
        public const int MF_Remove = 0x1000;
        public const int MF_ByCommand = 0x0;

        [DllImport("user32.dll")]
        public static extern IntPtr GetMenuItemID(IntPtr hMenu, int nPosition);

        [DllImport("user32.dll")]
        public static extern IntPtr GetSystemMenu(IntPtr hwnd, bool bRevert);

        [DllImport("user32.dll")]
        public static extern bool RemoveMenu(IntPtr hMenu, int nPosition, int wFlag);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonRemove_Click(object sender, EventArgs e)
        {
            IntPtr hSystemMenu = GetSystemMenu(this.Handle, false);
            if (hSystemMenu == IntPtr.Zero) return;

            //Remove By Position
            RemoveMenu(hSystemMenu, 6, MF_ByPosition | MF_Remove);

            // minimize item position is 3
            IntPtr minimizeItemId = GetMenuItemID(hSystemMenu, 3);
            //Remove By Command
            RemoveMenu(hSystemMenu, minimizeItemId.ToInt32(), MF_ByCommand | MF_Remove);
        }
    }
}